import 'dart:math';

import 'package:photogram_admin_cp/ui/components/util_widgets.dart';
import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/data.dart';

class UserSearchPage extends StatefulWidget {
  const UserSearchPage({Key? key}) : super(key: key);

  @override
  _UserSearchPageState createState() => _UserSearchPageState();
}

class _UserSearchPageState extends State<UserSearchPage> with AppActiveContentInfiniteMixin {
  final _userIds = <int>{};

  var _valueToSearch = '';

  @override
  didChangeDependencies() {
    contentMixinClearState();

    _userIds.clear();

    _valueToSearch = Navigator.of(context).getValue('search');

    _loadUsers(latest: true);
  }

  @override
  build(context) {
    var itemCount = isLoadingBottom ? _userIds.length + 1 : _userIds.length;

    if (0 == itemCount) {
      if (isLoadingLatest) {
        return UtilWidgets.preloader('Searching...');
      }

      return UtilWidgets.noResults();
    }

    return ListView.builder(itemCount: itemCount, itemBuilder: _userItemBuilder);
  }

  Widget _userItemBuilder(BuildContext context, int index) {
    if (_userIds.length - 3 < index) {
      _loadUsers();
    }

    if (_userIds.length > index) {
      var userId = _userIds.elementAt(index);

      var userModel = activeContent.watch<UserModel>(userId);

      if (null != userModel) {
        return Division(
          style: 'max-width: 738px;',
          child: Division(
            className: 'content my-15',
            child: _buildUserTile(userModel),
          ),
        );
      }

      return const Division();
    }

    return UtilWidgets.smallPreloader();
  }

  Widget _buildUserTile(UserModel userModel) {
    return Division(
      className: 'list-tile animate__animated animate__fadeIn',
      children: [
        Division(
          onClick: (event) => _openUserEditPage(userModel.id),
          className: 'list-tile-leading pointer',
          child: Image(
            className: 'user-avatar',
            src: userModel.displayImage.urlCompressed,
          ),
        ),
        Division(
          className: 'list-tile-content',
          child: Division(
            className: 'p-10',
            children: [
              Division(
                onClick: (event) => _openUserEditPage(userModel.id),
                className: 'font-size-14 font-weight-medium hoverable-title pointer',
                innerText: userModel.name,
              ),
              Division(
                className: 'text-muted',
                innerText: '@${userModel.username}',
              ),
            ],
          ),
        ),
        Division(
          style: 'list-tile-trailing',
          child: Button(
            onClick: (event) => _openUserEditPage(userModel.id),
            className: 'btn',
            innerText: 'Edit profile',
          ),
        ),
      ],
    );
  }

  Future<void> _loadUsers({bool latest = false}) async {
    contentMixinLoadContent(
      latest: latest,
      responseHandler: handleResponse,
      latestEndpoint: REQ_TYPE_ADMIN_USER_SEARCH_LATEST,
      bottomEndpoint: REQ_TYPE_ADMIN_USER_SEARCH_BOTTOM,
      requestDataGenerator: () => {
        UserTable.tableName: {UserTable.displayName: _valueToSearch},
        RequestTable.offset: {
          UserTable.tableName: {UserTable.id: (latest) ? latestContentId : bottomContentId},
        },
      },
    );
  }

  handleResponse({
    bool latest = false,
    required ResponseModel responseModel,
  }) {
    activeContent.handleResponse(responseModel);

    activeContent.pagedModels<UserModel>().forEach((userId, userModel) {
      _userIds.add(userId);
    });

    contentMixinUpdateData(
      setLatestContentId: _userIds.isEmpty ? 0 : _userIds.reduce(max),
      setBottomContentId: _userIds.isEmpty ? 0 : _userIds.reduce(min),
    );

    setState(() {});
  }

  void _openUserEditPage(String userId) {
    Navigator.of(context).open(name: 'user', values: {'': userId});
  }
}
